IFNDEF negative_wdl; //{
DEFINE negative_wdl;

// Variables \\\\\\\\\\\\\\\\\\\\\\\\\{

var pixel_pos_x;
var pixel_pos_y;
var pixel_color[3];
bmap negative_map <screen_black.bmp>;
bmap screenshot_map <screen_black.bmp>;
panel negative_pan { layer 2; bmap negative_map; flags transparent,refresh;}

//}

function pixel_to_screen()
{
	// Initializing \\\\\\\\\\\\\\\\\\\{

	if(negative_pan.visible) {return;}

	var format;
	var pixel;
	pixel_pos_x = 0;
	pixel_pos_y = 0;
	bmap_for_screen(screenshot_map,1,0);
	wait(1);
	bmap_lock(negative_map,0);
	format = bmap_lock(screenshot_map,0);

	//}

	// Processing \\\\\\\\\\\\\\\\\\\\\{

	next_pixel:
		
		pixel = pixel_for_bmap(screenshot_map,pixel_pos_x,pixel_pos_y);
		pixel_to_vec(pixel_color,null,format,pixel);
		pixel_color.blue 	= 255-pixel_color.blue;
		pixel_color.green	= 255-pixel_color.green;
		pixel_color.red 	= 255-pixel_color.red;
		pixel = pixel_for_vec(pixel_color,null,format);
		pixel_to_bmap(negative_map,pixel_pos_x,pixel_pos_y,pixel);
		
		pixel_pos_x += sign(bmap_width(negative_map)-pixel_pos_x);
		pixel_pos_x %= bmap_width(negative_map);
		pixel_pos_y += 1-sign((bmap_width(negative_map)-1)-pixel_pos_x);
		
	if(pixel_pos_y < bmap_height(negative_map)) {goto(next_pixel);}

	//}

	// Output \\\\\\\\\\\\\\\\\\\\\\\\\{

	negative_pan.alpha = 100;

	//}

	// Shutdown \\\\\\\\\\\\\\\\\\\\\\\{

	bmap_unlock(negative_map);
	bmap_unlock(screenshot_map);

	//}
}

starter Negative()
{
	Negative_loop:
		negative_pan.visible = sign(negative_pan.alpha);
		negative_pan.alpha -= sign(negative_pan.visible);
		negative_pan.alpha = clamp(negative_pan.alpha,0,100);
		wait(1);
	goto(Negative_loop);
}

on_mouse_middle = pixel_to_screen;
//}
ENDIF;